
#ifndef _1_KMNG_SEP_Utils_h_H
#define _1_KMNG_SEP_Utils_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#include "KMNG_SEP_ATP_KeysOp.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Jul 10 10:39:43 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version KMNG_ATP_TST_UTIL_Funcs.h#1:incl:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs  ****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/
/*****************************************************************************
 * Function Name:                                                           
 * 	KMNG_TST_CheckErrorReturn 		
 * 
 * Inputs:
 * 	DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char 	 TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char 	 TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
 *
 * Outputs:
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function 
 * If the operation has succeeded of failed	the appropriate printing and return value
 *
 ******************************************************************************/
 DxError_t KMNG_TST_CheckErrorReturn(DxError_t  TST_ErrorRet,
                                     char       TST_FuncName[TST_FUNC_STRING_LEN],
                                     char       TST_SubTestName[TST_FUNC_STRING_LEN],
                                     char       TST_MasterTestName[TST_FUNC_STRING_LEN]);

 /*****************************************************************************
 * Function Name:                                                           
 * 	KMNG_TST_PrintCheckErrorReturn 		
 * 
 * Inputs:
 * 	DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char 	 TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char 	 TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
 *
 * Outputs:
 * 	DxUint8_t - Function error return		    					  		
 *
 * Description:																	
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function 
 * If the operation has succeeded of failed	the appropriate printing and return value
 *
 ******************************************************************************/
 DxError_t KMNG_TST_PrintCheckErrorReturn(DxError_t  TST_ErrorRet,
							  			  char       TST_FuncName[TST_FUNC_STRING_LEN],
										  char       TST_SubTestName[TST_FUNC_STRING_LEN],
										  char       TST_MasterTestName[TST_FUNC_STRING_LEN]);

 /*****************************************************************************
 * Function Name:
 *  KMNG_TST_CheckErrorReturnSuccededFailure
 *
 * Inputs:
 *  DxUint32_t  TST_ErrorRet - The return value of the checked function
 *  char        TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
 *  char        TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char        TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxUint8_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space
 * this function returns the appropriate printing for a checked function
 * If the operation has succeeded of failed the appropriate printing and return value
 *
 ******************************************************************************/
 DxError_t KMNG_TST_CheckErrorReturnSuccededFailure(DxError_t  TST_ErrorRet,
                                                     char       TST_FuncName[TST_FUNC_STRING_LEN],
                                                     char       TST_SubTestName[TST_FUNC_STRING_LEN],
                                                     char       TST_MasterTestName[TST_FUNC_STRING_LEN]);
 
 /*****************************************************************************
 * Function Name:                                                           
 * 	KMNG_LOG_TST 		
 * 
 * Inputs:
 * 	DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 * 	const char format,... - the printf format.	 
 *  
 * Outputs:
 *   None	    					  		
 *
 * Description:																	
 * The following function handles the printings logging of the testing suite . 
 *        This function should be called by using the KMNG_LOG_TST_PRINT macro
 *
 ******************************************************************************/							     
 #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        int KMNG_LOG_TST( DxUint8_t level , const char *format,... );
 #endif

 #if ATP_LOG_TST_MAX_LEVEL_ENABLED
        #define KMNG_LOG_TST_PRINT(args) (KMNG_LOG_TST args)
 #else
        #define KMNG_LOG_TST_PRINT(args)   
 #endif							     

/*****************************************************************************
 * Function Name:
 *  KMNG_TST_Check_Num_Of_Keys
 *
 * Inputs:
 *  DxUint32_t TST_ReceivedSymKey - received num of sym keys
 *  DxUint32_t TST_ExpectedSymKey - expected num of sym keys
 *  DxUint32_t TST_ReceivedRSAKey - received num of RSA keys
 *  DxUint32_t TST_ExpectedRSAKey - received num of RSA keys
 *  DxUint32_t TST_ReceivedDHKey - received num of DH keys
 *  DxUint32_t TST_ExpectedDHKey - received num of DH keys
 *
 * Outputs:
 *   None
 *
 * Description:
 *        The function checks if received keys equal to expected and prints
 *        if not.
 *
 ******************************************************************************/
//DxError_t KMNG_TST_Check_Num_Of_Keys(DxUint32_t TST_ReceivedSymKey,
//                                     DxUint32_t TST_ExpectedSymKey,
//                                     DxUint32_t TST_ReceivedRSAKey,
//                                     DxUint32_t TST_ExpectedRSAKey,
//                                     DxUint32_t TST_ReceivedDHKey,
//                                     DxUint32_t TST_ExpectedDHKey);

/*****************************************************************************
* Function Name:
*  KMNG_ATP_TST_PrintVersion
*
* Inputs:
*  KMNG_Version_t *DX_TST_version
*
* Outputs:
*   None
*
* Description:
*        The function Prints the KMNG version
*
******************************************************************************/
//void KMNG_ATP_TST_PrintVersion(KMNG_Version_t *DX_TST_version);

#ifdef __cplusplus
}
#endif

#endif



